{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 17.10.98 - 22:34:33 $                                        =}
{========================================================================}
unit Settings;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TPlaySettings = class(TForm)
    Bevel1: TBevel;
    Bevel2: TBevel;
    edArtist1: TEdit;
    edTitle1: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    OKButton: TButton;
    CancelButton: TButton;
    lbPlayList1: TListBox;
    edTrack1: TEdit;
    NameButton: TButton;
    TrackLabel1: TLabel;
    Label5: TLabel;
    AddButton: TButton;
    RemoveButton: TButton;
    ClearButton: TButton;
    ResetButton: TButton;
    lbTrackList1: TListBox;
    Label6: TLabel;
    procedure ListMouseUp(Sender: TObject; Button: TMouseButton;
                          Shift: TShiftState; X, Y: Integer);
    procedure edTrack1Enter(Sender: TObject);
    procedure edTrack1Exit(Sender: TObject);
    procedure ListKeyUp(Sender: TObject; var Key: Word;
                        Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure NameButtonClick(Sender: TObject);
    procedure ListDrawItem(Control: TWinControl; Index: Integer;
                           Rect: TRect; State: TOwnerDrawState);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure ResetButtonClick(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure RemoveButtonClick(Sender: TObject);
    procedure ListDragOver(Sender, Source: TObject; X, Y: Integer;
                           State: TDragState; var Accept: Boolean);
    procedure ListDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ListEndDrag(Sender, Target: TObject; X, Y: Integer);
  private
  public
    DragTarget: TListBox;
    aTimer    : TTimer;
    aBitmap1  : TBitmap;
    aBitmap2  : TBitmap;
    aIcon     : TIcon;
    oldIndex  : integer;

    procedure SetButtons;
    procedure SetTrackLabel;
    function  FirstSelection(aList: TListBox): Integer;
    function  LastSelection(aList: TListBox): Integer;
    procedure SetItem(aList: TListBox; aIndex: Integer);
    function  FindIndex(aList: TListBox; aPos: TPoint): integer;
    procedure ClearSelected(aList: TListBox);
    procedure AddSelected(aIndex: integer);
    procedure ResortSelected(aIndex: integer);
    procedure RemoveSelected;
    procedure DrawIndexPtr(oldIndex, newIndex: integer);
    procedure DragTimerExpired(Sender: TObject);
  end;

var
  PlaySettings: TPlaySettings;

implementation

{$R *.DFM}

const
  crTrackDrag   = 1;
  crTrackAdd    = 2;
  crTrackDelete = 3;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.SetButtons;
begin
     AddButton.Enabled    := (lbTrackList1.SelCount > 0);
     RemoveButton.Enabled := (lbPlayList1.SelCount > 0);
     ClearButton.Enabled  := (lbPlayList1.Items.Count > 0);
     ResetButton.Enabled  := (lbTrackList1.Items.Count > 0);
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.SetTrackLabel;
Var
   aIndex: integer;
   aStr: String;

begin
     with lbTrackList1 do
     begin
          aIndex := FirstSelection(lbTrackList1);
          if aIndex = LB_Err then aIndex := ItemIndex;
          edTrack1.Text := Items.Strings[aIndex];
          aStr := 'Trac&k ';
          if aIndex < 9 then
             aStr := aStr + '0';
          TrackLabel1.Caption := aStr + IntToStr(aIndex+1) + ':';
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
function TPlaySettings.FirstSelection(aList: TListBox): Integer;
begin
     for Result := 0 to aList.Items.Count-1 do
         if aList.Selected[Result] then exit;
     Result := LB_ERR;
end;

{-- TPlaySettings --------------------------------------------------------}
function TPlaySettings.LastSelection(aList: TListBox): Integer;
begin
     for Result := aList.Items.Count-1 downTo 0 do
         if aList.Selected[Result] then exit;
     Result := LB_ERR;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.SetItem(aList: TListBox; aIndex: Integer);
Var
  MaxIndex: Integer;

begin
     with aList do
     begin
          MaxIndex := aList.Items.Count-1;
          if aIndex = LB_ERR then aIndex := MaxIndex
          else if aIndex > MaxIndex then aIndex := 0;
          Selected[aIndex] := True;
     end;
     SetButtons;
end;

{-- TPlaySettings --------------------------------------------------------}
function  TPlaySettings.FindIndex(aList: TListBox; aPos: TPoint): integer;
begin
     with aList do
     begin
          Result := ItemAtPos(aPos, False);
          if Items.Count > (Height div ItemHeight)-1 then
             if Result = TopIndex + (Height div ItemHeight)-1 then
                   if aPos.Y > Height-(ItemHeight div 2) then
                      inc(Result);
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ClearSelected(aList: TListBox);
Var
   aIndex: integer;

begin
     aIndex := FirstSelection(aList);
     if aIndex > LB_Err then
        while aIndex <= LastSelection(aList) do
        begin
             if aList.Selected[aIndex] then
                aList.Selected[aIndex] := False;
             inc(aIndex);
        end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.AddSelected(aIndex: integer);
Var
  i: Integer;

begin
     with lbPlayList1 do
     begin
          if (aIndex = -1) then aIndex := Items.Count;

          for i := 0 to lbTrackList1.Items.Count-1 do
              if lbTrackList1.Selected[i] then
              begin
                 Items.Insert(aIndex, lbTrackList1.Items[i]);
                 inc(aIndex);
              end;

          if aIndex >= lbPlayList1.Height div ItemHeight then
             TopIndex := aIndex-((lbPlayList1.Height div ItemHeight)-1);
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ResortSelected(aIndex: integer);
Var
  i: Integer;

begin
     with lbPlayList1 do
     begin
          if (aIndex = -1) then
             aIndex := 0;

          i := 0;
          while i < Items.Count do
          begin
              if Selected[i] then
              begin
                   Selected[i] := False;
                   if aIndex > i then
                   begin
                        Items.Move(i, aIndex-1);
                        dec(i);
                   end
                   else
                   begin
                        Items.Move(i, aIndex);
                        inc(aIndex);
                   end;
              end;
              inc(i);
          end;

          if (Items.Count > 0) then
          begin
               TopIndex := 0;
               Selected[0] := True;
               Selected[0] := False;
          end;
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.RemoveSelected;
Var
  i: Integer;

begin
     with lbPlayList1 do
     begin
          ItemIndex := 0;
          for i := Items.Count-1 downTo 0 do
              if Selected[i] then 
                 Items.Delete(i);

          if (Items.Count > 0) then 
          begin
               TopIndex := 0;
               Selected[0] := True;
               Selected[0] := False;
          end;
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ListMouseUp(Sender: TObject;
          Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if Button = mbLeft then
     begin
          if (Sender = lbTrackList1) then SetTrackLabel;
          SetButtons;
     end;     
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ListKeyUp(Sender: TObject; var Key: Word;
                                          Shift: TShiftState);
begin
     if (Sender = lbTrackList1) then SetTrackLabel;
     SetButtons;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.edTrack1Enter(Sender: TObject);
begin
     OKButton.Default := False;
     NameButton.Default := True;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.edTrack1Exit(Sender: TObject);
begin
     NameButton.Default := False;
     OKButton.Default := True;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.NameButtonClick(Sender: TObject);
Var
   i, aIndex: integer;

begin
     with lbTrackList1 do
     begin
          aIndex := ItemIndex;

          if Items[aIndex] <> edTrack1.Text then
          begin
             i := lbPlayList1.Items.IndexOf(Items[aIndex]);
             if i <> -1 then
             lbPlayList1.Items[i] := edTrack1.Text;

             Items[aIndex] := edTrack1.Text;
          end;

          ClearSelected(lbTrackList1);

          SetItem(lbTrackList1, aIndex+1);

          SetTrackLabel;
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.FormCreate(Sender: TObject);
begin
     aTimer := TTimer.Create(Self);
     aTimer.Interval := 50;
     aTimer.Enabled := False;
     aTimer.OnTimer := DragTimerExpired;

     aBitmap1 := TBitmap.Create;
     aBitmap2 := TBitmap.Create;
     aBitmap1.Handle := LoadBitmap(HInstance, 'CD_NOTE');
     aBitmap2.Width := aBitmap1.Width;
     aBitmap2.Height := aBitmap1.Height;
     BitBlt(aBitmap2.Canvas.Handle, 0,0, aBitmap1.Width, aBitmap1.Height,
            aBitmap1.Canvas.Handle, 0,0, NOTSRCCOPY);

     aIcon := TIcon.Create;
     aIcon.Handle := LoadIcon(HInstance, 'MARKERICON');
     oldIndex := -1;

     Screen.Cursors[crTrackDrag] := LoadCursor(HInstance, 'CD_CR_TRACKDRAG');
     Screen.Cursors[crTrackAdd] := LoadCursor(HInstance, 'CD_CR_TRACKADD');
     Screen.Cursors[crTrackDelete] := LoadCursor(HInstance, 'CD_CR_TRACKDELETE');

     DragTarget := Nil;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.FormDestroy(Sender: TObject);
begin
     aTimer.Free;
     aBitmap1.Free;
     aBitmap2.Free;
     aIcon.Free;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.FormShow(Sender: TObject);
begin
     SetTrackLabel;
     SetButtons;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ListDrawItem(Control: TWinControl;
          Index: Integer; Rect: TRect; State: TOwnerDrawState);
Var
  Offset: Integer;

begin
     with (Control as TListBox), (Control as TListBox).Canvas do
     begin
          FillRect(Rect);
          Offset := 1;

          if (odSelected in State) then
             BrushCopy(Bounds(Rect.Left + Offset, Rect.Top,
                              aBitmap2.Width, aBitmap2.Height),
                       aBitmap2,
                       Bounds(0, 0, aBitmap2.Width, aBitmap2.Height),
                       clBlack)
          else
             BrushCopy(Bounds(Rect.Left + Offset, Rect.Top,
                              aBitmap1.Width, aBitmap1.Height),
                       aBitmap1,
                       Bounds(0, 0, aBitmap1.Width, aBitmap1.Height),
                       clWhite);

          Offset := Offset + aBitmap1.Width + 5;
          TextOut(Rect.Left + Offset, Rect.Top, Items[Index]);
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.AddButtonClick(Sender: TObject);
begin
     AddSelected(-1);
     SetButtons;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.RemoveButtonClick(Sender: TObject);
begin
     RemoveSelected;
     SetButtons;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ClearButtonClick(Sender: TObject);
begin
     lbPlayList1.Clear;
     SetButtons;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ResetButtonClick(Sender: TObject);
begin
     lbPlayList1.Items := lbTrackList1.Items;
     SetButtons;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.DragTimerExpired(Sender: TObject);
Var
   MousePos: TPoint;

begin
     if DragTarget <> Nil then
     begin
        GetCursorPos(MousePos);
        MousePos := ScreenToClient(MousePos);

        with DragTarget do
        begin
           if (MousePos.X > Left) And (MousePos.X < Left + Width) then
           begin
              { scroll the listbox up }
              if (MousePos.Y < Top) And (TopIndex > 0) then
                 TopIndex := TopIndex - 1
              else
              { scroll the listbox down }
              if (MousePos.Y > Top + Height) And (TopIndex < Items.Count - (Height div ItemHeight)) then
                 TopIndex := TopIndex + 1;
           end;
        end;
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.DrawIndexPtr(oldIndex, newIndex: integer);
const
     Offset: integer = 2;

begin
     with Canvas do
     begin
          if oldIndex <> LB_Err then
          begin
               with lbPlayList1 do
                  oldIndex := (oldIndex - TopIndex) * ItemHeight + Top - 5;
               Brush.Color := Self.Color;
               FillRect(Rect(Offset,oldIndex,
                             Offset+15,
                             oldIndex+15));
          end;
          if newIndex <> LB_Err then
          begin
               with lbPlayList1 do
                  newIndex := (newIndex - TopIndex) * ItemHeight + Top - 5;
               Draw(Offset, newIndex, aIcon);
          end;
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ListDragOver(Sender, Source: TObject;
                        X, Y: Integer; State: TDragState;
                        Var Accept: Boolean);
Var
   curIndex: integer;

begin
     if (Source is TListBox) And (Sender is TListBox) then
     begin
          Accept := True;

          { set the right drag cursors }
          if (State = dsDragEnter) then
          begin
             if Source = lbPlayList1 then
             begin
                if Sender = lbPlayList1 then
                   TListBox(Source).DragCursor := crTrackDrag
                else
                   TListBox(Source).DragCursor := crTrackDelete;
             end
             else
             begin
                if Sender = lbTrackList1 then
                   TListBox(Source).DragCursor := crTrackDrag
                else
                   TListBox(Source).DragCursor := crTrackAdd;
             end;

             aTimer.Enabled := False;
             DragTarget := TListBox(Sender);
          end
          else if (State = dsDragLeave) then
                  aTimer.Enabled := True;

          { don't accept if on the scrollbars }
          with TListBox(Sender) do
          begin
             curIndex := ItemAtPos(Point(X,Y),False);
             if curIndex = LB_Err then Accept := False;
          end;

          { now draw the index arrow }
          if (Sender = lbPlayList1) then
          begin
             {special case for the last visible item }
             curIndex := FindIndex(TListBox(Sender), Point(X, Y));

             if (curIndex <> oldIndex) Or (State = dsDragLeave) then
             begin
                if (State = dsDragEnter) then
                   oldIndex := LB_Err;

                if (State = dsDragLeave) then
                   curIndex := LB_Err;

                DrawIndexPtr(oldIndex, curIndex);

                oldIndex := curIndex;
             end;
          end;
     end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ListDragDrop(Sender, Source: TObject;
                                     X, Y: Integer);
Var
  aIndex: Integer;

begin
    { make sure source and destination components are list boxes }
    if (Source is TListBox) and (Sender is TListBox) then
    begin
         if (Sender = lbTrackList1) then
         begin
              { delete selected items }
              if (Source = lbPlayList1) then
                 RemoveSelected;
         end
         else
         begin
              { copy from one list to another }
              if (Source = lbTrackList1) then
              begin
                   { find destination position in list box }
                   aIndex := FindIndex(TListBox(Sender), Point(X, Y));
                   AddSelected(aIndex);
              end
              else { rearrange list }
              begin
                   { find destination position in list box }
                   aIndex := FindIndex(TListBox(Sender), Point(X, Y));
                   ReSortSelected(aIndex);
              end;
         end;
    end;
end;

{-- TPlaySettings --------------------------------------------------------}
procedure TPlaySettings.ListEndDrag(Sender, Target: TObject; X, Y: Integer);
begin
     aTimer.Enabled := False;
     DragTarget := Nil;
end;

end.


